//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help


//Special Events

+ DrumTrackSystem {

//must be at least 45 second diskins
breakcore {
	
	l.addenv(
					
		LCOK(\breakcore,{arg index, group;
			var which, synth, disksynth;
			
			//\hdtgravitygrid1 too CPU expensive to have more than one- need a cost scheme
			which= synthdata.wchoose(synthprob).value;
							
			disksynth=Synth.head(group,\hdtdiskin,[\outbus,diskinbus.index, \bufnum, diskinbuf[whichdiskin].bufnum]);
		
			whichdiskin=whichdiskin+1;
		
			//trackindex
			synth=Synth.tail(group,\hdtbreakcore,[\bufnum, breakcorebuf.bufnum, \outbus,index,\trigbus,[snareonsets.index, kickonsets.index, (beatbus.index+(3.rand))].choose, \inbus,diskinbus.index,\tempobus, beatbus.index+3]);
		
	}),0.0,1,Env([0,1,1,0],[rrand(0,10),rrand(10,20),rrand(5,14)]));

}

gravitygrid {
	
	l.addenv(
					
		LCOK(\gravitygrid,{arg index, group;
		 
			var which, synth;
			
			//\hdtgravitygrid1 too CPU expensive to have more than one- need a cost scheme
			which= synthdata.wchoose(synthprob).value;
			
			synth=Synth.head(group,\hdtgravitygrid1,[\outbus,index,\onsetbus,[snareonsets.index, kickonsets.index, (beatbus.index+(3.rand))].choose, \inbus, kitenergy.index]);
		
	}),0.0,1,Env([0,1,1,0],[rrand(5,15),rrand(10,30),rrand(5,15)]));

}


//cannot overlap these in time else may screw up
popsteal {
	
			//need to know the length of the diskin for accurate scheduling- assume no more than 60 seconds can be extracted?
	
	//can only use each diskin once
	if(whichdiskin<(diskinbuf.size),{
	
	l.addenv(
					
		LCOK(("popsteal" ++ (whichdiskin.asString)).asSymbol,{arg index, group;
			var synth, grp, cutter;
			
			//grp=Group.head(group);
					
			synth=Synth.head(group,\hdtdiskin,[\outbus,diskinbus.index, \bufnum, diskinbuf[whichdiskin].bufnum]);
		
			whichdiskin=whichdiskin+1;
		
			//use BBCut2 to run a Task which respects beat phase shifts
			
			//ce.run(true);
					
			//CutCE cuts up captured event database with user defined functions about which index when relative to most recent=0
			
			"index".postln;
			index.postln;
			
			[\diskinbus,diskinbus.index].postln;
			
			cutter=BBCut2(CutGroup([CutCE(ce,{arg block; Array.fill(block.cuts.size,{0}); }),CutMixer(index,1.0,1.0,0.5.rand2)],group),ChooseCutProc({[0.5,0.25,1.0].choose},{[1,2,4].choose},rollchance:0.0)).play(c);
					
			//this.makecutproc
			//ce.run(false);
			[{},{cutter.end;}]
	}),0.0,1,Env([0,1,1,0],[rrand(0,10),rrand(10,20),rrand(5,14)]));
	
	});

}


//audioincutter to sync up to drums
firstcut {

l.addenv(
					
		LCOK(\firstcut,{arg index, group;
		var cutter, grp, cutgroup, cutsynth, targetindex;
		var whichcap;
		
		"creating".postln;		
		targetindex= trackindex+1; //start with snare
		
			//grp=Group.head(group);
			whichcap= capbufsavailable.pop;
	cutter=BBCut2(CutGroup([CutStream1(targetindex,capbufs[whichcap]),CutMixer(index,1.0,1.0,0.3.rand2)],group),ChooseCutProc({[0.5,0.25,1.0].wchoose([0.1,0.9,0.1])},{[2,4].choose},rollchance:0.2)).play(c);
			
	runningcutters=runningcutters+1;
	
	[{},{cutter.end;runningcutters=runningcutters-1;  
	capbufsavailable.addFirst(whichcap); }]
	
	 	}),0.0,1,Env([1,1],[30]));
		

}




//
//sortbuf {
//
//}

//60 seconds
start {
	
	l.addenv(
	
	LCOK(\start,{arg index, group; 
	var which, synth;
	
	synth=Synth.head(group,\hdtnastynoise3,[\outbus,index]);
	
	}),0.0,1,Env([0,1,1,0],[10,40,10]));

}

startend {
	
	l.addenv(
	
	LCOK(\start,{arg index, group; 
	var which, synth;
	
	synth=Synth.head(group,\hdtnastynoise3,[\outbus,index]);
	
	}),0.0,1,Env([0,1,1,0],[20,39.9,0.2]));

}


//takes 30 seconds
end {
	
	l.addenv(
	
	LCOK(\end,{arg index, group; 
	var which, synth;
	
	synth=Synth.head(group,\hdtnastynoise1,[\outbus,index]);
	
	}),0.0,1,Env([0,1,1,0],[10,19.8,0.2]));

}


//some values to depend on aggression level
makesynth {
	var name,timespan;
	
	name= ("synth" ++ (nextnum.asString)).asSymbol;
	
	name.postln;
	
	nextnum=nextnum+1;
	
	timespan= rrand(10,20);
	
	//prob  of choosing which type of element, to revise later and make clear
	
	l.addenv(
	
	LCOK(name,{arg index, group; 
	var which, synth;
	
	//\hdtgravitygrid1 too CPU expensive to have more than one- need a cost scheme
	which= synthdata.wchoose(synthprob).value;
	
	which[0].postln;
	
	synth=Synth.head(group,which[0],[\outbus,index]++(which[1]));
	
	runningsynths=runningsynths+1;
	
	//synth.free; //not needed since LiveCoding1 clears out the bus  
	[{},{runningsynths=runningsynths-1;  }];
	
	//0,rrand(0.25,1.0),exprand(0.25,1.0),0
	}),0.0,1,Env([0,1,1,0],[exprand(0.1,0.6),rrand(0.5,1),exprand(0.1,0.6)].normalizeSum*timespan));
	 
}



makecutter {
	var name,timespan;
	
	name= ("cut" ++ (nextnum.asString)).asSymbol;
	
	name.postln;
	
	nextnum=nextnum+1;
	
	timespan= rrand(10,20);
	
	l.addenv(
	LCOK(name,{arg index, group; 
	var cutter, grp, cutgroup, cutsynth, targetindex, trackson;
	var whichcap;
	
	//must make, will be killed o/w
	//grp=Group.head(group);
	
	//can attack tracks with numbers lower than itself- need a better way to check up on the
	//running track numbers
	
	trackson= l.tracksinuse;
	
	//Post << "available " << trackson << nl;
	
	//note may assign something after itself
	trackson= if(trackson.isEmpty,{5.rand+1},{trackson.choose;});
	targetindex= [trackindex+(2.rand),l.tracks.at(l.tracksinuse.choose).bus.index].choose;
	
	whichcap= capbufsavailable.pop;
	
	//Post << [\whichcap, whichcap, \runningcutters, runningcutters] << nl;
	
	//this may lead to them using the same buffers- need to track which in use
	//just mono capture
	//cutgroup= CutGroup([, CutMixer(index,1.0,1.0,0.5.rand2)],s,grp); 
	
	cutsynth= [CutStream1(targetindex,capbufs[whichcap]), this.makecutmixer];
	
	if(0.3.coin,{
	cutsynth= cutsynth++(this.addfx);
	});
	
	//BBCutBuffer, could compensate for original tempo bps
	cutgroup= CutGroup(cutsynth,group); 	
	
	//running from this point
	cutter=BBCut2(cutgroup,this.makecutproc).play(c);
	
	runningcutters=runningcutters+1;
	
	[{},{cutter.end;runningcutters=runningcutters-1; 
	//can't add immediately for safety reasons, actually, should be OK
	//SystemClock.sched(0.5,{capbufsavailable.addFirst(whichcap);nil}); 
	capbufsavailable.addFirst(whichcap); 
	
	 }]
	 
	 //0,rrand(0.25,1.0),exprand(0.25,1.0),0
	}),0.0,1,Env([0,1,1,0],[exprand(0.1,0.6),rrand(0.5,1),exprand(0.1,0.6)].normalizeSum*timespan))
	
	

}

//moved function array elsewhere so made once only, saves CPU
makecutproc {
^cutoptions.choose.value;
}



makebeat {
	var name,timespan;
	
	name= ("beat" ++ (nextnum.asString)).asSymbol;
	
	name.postln;
	
	nextnum=nextnum+1;
	
	timespan= rrand(10,20);
	
	l.addenv(
	LCOK(name,{arg index, group; 
	var cutter, grp, cutgroup, targetindex, trackson;
	var whichbreak, cutsynth;
	
	//must make, will be killed o/w
	//grp=Group.head(group);
	
	cutsynth= [{this.makecutbuf2},{this.makecutkick1}].choose.value; 
	
	//CutMixer(index,1.0,1.0,0.5.rand2)
	cutsynth= [cutsynth, this.makecutmixer];
	
	//add FX? 
	
	cutsynth= cutsynth++(this.addfx);
	
	//BBCutBuffer, could compensate for original tempo bps
	//, CutFXSwap1.new
	cutgroup= CutGroup(cutsynth,group); 
	
	//running from this point
	cutter=BBCut2(cutgroup,this.makecutproc).play(c);
	
	runningbeats=runningbeats+1;
	
	[{},{cutter.end;runningbeats=runningbeats-1; 
	 }]
	 
	 //0,rrand(0.1,0.7),exprand(0.1,0.7),0
	 
	 //Env([1,1,1,1],[exprand(0.1,0.6),rrand(0.5,1),exprand(0.1,0.6)].normalizeSum*timespan)
	}),0.0,1,Env([1,1],[timespan]))

}


//based on activity levels
makecutmixer {arg outbus;
	var panfunc, ampfunc;
	var tmp,tmp2;

	tmp=rrand(0.0,0.7);
	tmp2=exprand(0.01,0.3);
	
	panfunc=[
	0.0,
	0.3.rand2,
	0.6.rand2,
	0.9.rand2,
	{((-1)**(2.rand))*(rrand(tmp,tmp+tmp2))}, //annulus
	{0.3.rand2},
	{0.9.rand2},
	{arg i, block; (2.0*i/(block.cuts.size))-1.0},
	{arg i, block; (2.0*(block.cuts.size-i)/(block.cuts.size))-1.0},
	{tmp=(tmp+(tmp2.rand))%1.0; 2*tmp-1},
	{tmp=(tmp+(tmp2.rand2))%1.0; 2*tmp-1}
	].wchoose([0.35,0.2,0.1,0.05,0.1,0.1,0.025,0.025,0.025,0.025]);

	//BBCutBlock

	ampfunc=[
	1.0,
	{if(activity.coin,1.0,0.0)},
	{if(activity.coin,{activity},0.0)},
	{activity},
	{arg i, block; (activity*(i+1)/(block.cuts.size))},
	{arg i, block; (activity*(block.cuts.size-(i+1))/(block.cuts.size))}
	].wchoose([0.3,0.2,0.2,0.2,0.05,0.05]);
	
//ampfunc,panfunc	
^CutMixer(outbus,1.0,ampfunc,panfunc);
}



makecutkick1 {
	var b, indexfunc, rollprob, pbfunc, dutycycle;
	
	b= [kicks.choose,snares.choose,hats.choose]; 
	
	if(0.2.coin,{b.scramble});
	
	indexfunc= [
	{arg i; [0,2,0,1].wrapAt(i.blocknum)},
	{arg i; (i.blocknum)%3},
	{arg block; var i; i= block.blocknum; (i*i)%3},
	{arg i; 3.rand},
	{arg i; [0,1,2].wchoose([0.2,0.3,0.5])},
	].choose;
	
	rollprob= [
	[0.0,0.2,0.4],
	[0.2,0.3,0.4],
	[0.0,[0.0,rrand(0.0,1.0)].choose,rrand(0.0,1.0)],
	[rrand(0.0,1.0),rrand(0.0,1.0),rrand(0.0,1.0)]
	].choose; 
	
	pbfunc= [
	1.0,
	{if(0.1.coin,1.0,0.5)},
	{[0.5,1.0,2.0].wchoose([0.2,0.7,0.1])}
	].wchoose([0.7,0.2,0.1]);
	
	dutycycle =[
	1.0,
	rrand(0.5,1.0),
	exprand(0.1,1.0),
	{rrand(0.5,1.0)},
	{exprand(0.1,1.0)},
	{[0.1,0.9].wchoose([0.9,0.1])},
	].wchoose([0.5,0.25,0.1,0.05,0.05,0.05]);
	
	^CutTrig1(b,indexfunc,rollprob, pbfunc, dutycycle);
}

makecutbuf2 {
	var b, indexfunc, rollprob, pbfunc, dutycycle;
	
	pbfunc= [
	1.0,
	{if(0.1.coin,1.0,0.5)},
	{[0.5,1.0,2.0].wchoose([0.2,0.7,0.1])}
	].wchoose([0.7,0.2,0.1]);
	
	dutycycle =[
	1.0,
	rrand(0.5,1.0),
	exprand(0.1,1.0),
	{rrand(0.5,1.0)},
	{exprand(0.1,1.0)},
	{[0.1,0.9].wchoose([0.9,0.1])},
	].wchoose([0.5,0.25,0.1,0.05,0.05,0.05]);
	
^CutBuf2(breaks.choose,[0.0,rrand(0.0,1.0
)].wchoose([0.3,0.7]),pbfunc, dutycycle)
}

addfx {
	var basic, numfx;
	
	basic = List[];
	
	//code from CutFXSwap1
	
	numfx= [0,1,2,3,4].wchoose([0.6,0.2,0.1,0.05,0.05]);
	
	numfx.do({arg j;
	basic.add(fxoptions.wchoose([0.3,0.3,0.2,0.1,0.05,0.05]).value);
					
	});
	
	if (0.1.coin,{basic.add(CutFXSwap1(rrand(1,5),rrand(0.2,0.8), rrand(0.2,0.8)))});
	//
//	Post << "fx list " << basic << nl; 
//	
//	basic.do({arg val; val.class.postln;});  
//	
	^basic
}


otherclock {
	var clocksynth, tempo;
	
	tempo= exprand(2.3,3.5);
	
	"otherclock".postln;
	tempo.postln;
	
	clocksynth= Synth.tail(synthgroup,\hdtimpulse,[\outbus,externalbus.index,\freq,tempo]);
	
	if(0.8.coin,{
	tracksynth.set(\inductprop,0.0, \externalprop,1.0); 	},{
	tracksynth.set(\inductprop,1.0, \externalprop,1.0); 
	});
		
	//to last 20-40 seconds
	SystemClock.sched(rrand(20,40),{
	tracksynth.set(\inductprop,1.0, \externalprop,0.0); 
	clocksynth.free; 
	nil
	});
}



nasty2 {
	
	l.addenv(
	
	LCOK(\nasty2,{arg index, group; 
	var which, synth;
	
	synth=Synth.head(group,\hdtnastynoise2,[\outbus,index]);
	
	}),0.0,1,Env([0,1,1,0],[10,25,10],'sine'));

}


nasty4 {

	l.addenv(
	
	LCOK(\nasty4,{arg index, group; 
	var which, synth;
	
	synth=Synth.head(group,\hdtnastynoise4,[\outbus,index]);
	
	}),0.0,1,Env([0,1,1,0],[10,25,10],'sine'));

}


gendy1 {

	"go gendy1!".postln;

	l.addenv(
	
	LCOK(\gendy1,{arg index, group; 
	var which, synth;
	
	which= synthdata[3].value;
	
	synth=Synth.head(group,which[0],[\outbus,index]++(which[1]));	
	}),0.0,1,Env([0,1,1,0],[10,25,10],'sine'));

}

//section ideas
suppression {
var names;

names= [\hdtsuppress1,\hdtsuppress2,\hdtsuppress3];

Task({

3.do({arg i;

	l.addenv(
	
	LCOK(names[i],{arg index, group; 
	var which, synth;
	
	synth=Synth.head(group,names[i],[\outbus,index, \inbus,kitenergy.index,\suppress,rrand(27,47)]);
	
	}),0.0,1,Env([0,1,1,0],[10,10,10]));

10.wait;
	
});

},SystemClock).start;


}




support {
var names;

names= [\hdtsupport1,\hdtsupport2];

Task({

2.do({arg i;

	l.addenv(
	
	LCOK(names[i],{arg index, group; 
	var which, synth;
	
	synth=Synth.head(group,names[i],[\outbus,index, \inbus,kitenergy.index,\suppress,rrand(27,47)]);
	
	}),0.0,1,Env([0,1,1,0],[10,20,10]));

	0.5.wait;
	
});

},SystemClock).start;


}




}